# SPDX-FileCopyrightText: 2017 Scott Shawcroft, written for Adafruit Industries
# SPDX-FileCopyrightText: Copyright (c) 2023 Melissa LeBlanc-Williams for Adafruit Industries
#
# SPDX-License-Identifier: MIT

"""
`adafruit_qualia.displays.round21`
================================================================================

2.1" 480x480 Round DotClock Display Class


* Author(s): Melissa LeBlanc-Williams

Implementation Notes
--------------------

**Hardware:**

* `Round RGB 666 TTL TFT Display - 2.1" 480x480 - Capacitive Touch
  <https://www.adafruit.com/product/5792>`_
* `Round RGB TTL TFT Display - 2.1" 480x480 - No Touchscreen
  <https://www.adafruit.com/product/5806>`_

"""

from . import TOUCH_CST826, DotClockDisplay


class Round21(DotClockDisplay):
    """TL021WVC02 display driver"""

    def __init__(self):
        super().__init__()
        self._init_sequence = bytes(
            (
                0xFF,
                0x05,
                0x77,
                0x01,
                0x00,
                0x00,
                0x10,
                0xC0,
                0x02,
                0x3B,
                0x00,
                0xC1,
                0x02,
                0x0B,
                0x02,
                0xC2,
                0x02,
                0x00,
                0x02,
                0xCC,
                0x01,
                0x10,
                0xCD,
                0x01,
                0x08,
                0xB0,
                0x10,
                0x02,
                0x13,
                0x1B,
                0x0D,
                0x10,
                0x05,
                0x08,
                0x07,
                0x07,
                0x24,
                0x04,
                0x11,
                0x0E,
                0x2C,
                0x33,
                0x1D,
                0xB1,
                0x10,
                0x05,
                0x13,
                0x1B,
                0x0D,
                0x11,
                0x05,
                0x08,
                0x07,
                0x07,
                0x24,
                0x04,
                0x11,
                0x0E,
                0x2C,
                0x33,
                0x1D,
                0xFF,
                0x05,
                0x77,
                0x01,
                0x00,
                0x00,
                0x11,
                0xB0,
                0x01,
                0x5D,
                0xB1,
                0x01,
                0x43,
                0xB2,
                0x01,
                0x81,
                0xB3,
                0x01,
                0x80,
                0xB5,
                0x01,
                0x43,
                0xB7,
                0x01,
                0x85,
                0xB8,
                0x01,
                0x20,
                0xC1,
                0x01,
                0x78,
                0xC2,
                0x01,
                0x78,
                0xD0,
                0x01,
                0x88,
                0xE0,
                0x03,
                0x00,
                0x00,
                0x02,
                0xE1,
                0x0B,
                0x03,
                0xA0,
                0x00,
                0x00,
                0x04,
                0xA0,
                0x00,
                0x00,
                0x00,
                0x20,
                0x20,
                0xE2,
                0x0D,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0xE3,
                0x04,
                0x00,
                0x00,
                0x11,
                0x00,
                0xE4,
                0x02,
                0x22,
                0x00,
                0xE5,
                0x10,
                0x05,
                0xEC,
                0xA0,
                0xA0,
                0x07,
                0xEE,
                0xA0,
                0xA0,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0xE6,
                0x04,
                0x00,
                0x00,
                0x11,
                0x00,
                0xE7,
                0x02,
                0x22,
                0x00,
                0xE8,
                0x10,
                0x06,
                0xED,
                0xA0,
                0xA0,
                0x08,
                0xEF,
                0xA0,
                0xA0,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0x00,
                0xEB,
                0x07,
                0x00,
                0x00,
                0x40,
                0x40,
                0x00,
                0x00,
                0x00,
                0xED,
                0x10,
                0xFF,
                0xFF,
                0xFF,
                0xBA,
                0x0A,
                0xBF,
                0x45,
                0xFF,
                0xFF,
                0x54,
                0xFB,
                0xA0,
                0xAB,
                0xFF,
                0xFF,
                0xFF,
                0xEF,
                0x06,
                0x10,
                0x0D,
                0x04,
                0x08,
                0x3F,
                0x1F,
                0xFF,
                0x05,
                0x77,
                0x01,
                0x00,
                0x00,
                0x13,
                0xEF,
                0x01,
                0x08,
                0xFF,
                0x05,
                0x77,
                0x01,
                0x00,
                0x00,
                0x00,
                0x36,
                0x01,
                0x00,
                0x3A,
                0x01,
                0x60,
                0x11,
                0x80,
                0x64,
                0x29,
                0x80,
                0x32,
            )
        )

        self._timings = {
            "frequency": 16_000_000,
            "width": 480,
            "height": 480,
            "hsync_pulse_width": 20,
            "hsync_front_porch": 40,
            "hsync_back_porch": 40,
            "vsync_pulse_width": 10,
            "vsync_front_porch": 40,
            "vsync_back_porch": 40,
            "hsync_idle_low": False,
            "vsync_idle_low": False,
            "de_idle_high": False,
            "pclk_active_high": True,
            "pclk_idle_high": False,
        }

        self._touch_driver = TOUCH_CST826
        self._touch_address = 0x15
        self._round = True
